/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoXMLProperties;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFFactory;
import java.io.File;
import java.util.List;

public class UDFLibrary {
    public BlockGroup getUDFBlockGroup() {
        BlockGroup udfRoot = new BlockGroup(Language.getString("blockGroup.UDF", "UDF"));
        List<String> paths = LogoXMLProperties.getInstance().getLibraryProperties(false);
        for (String path : paths) {
            this.importUDFFiles(udfRoot, new File(path));
        }
        return udfRoot;
    }

    private void importUDFFiles(BlockGroup currentGroup, File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            BlockGroup newGroup = new BlockGroup(file.getName());
            currentGroup.addElement(newGroup);
            for (File f : file.listFiles()) {
                this.importUDFFiles(newGroup, f);
            }
        } else if (file.getName().toLowerCase().endsWith(".lma")) {
            UDFBlock udfBlock = new UDFBlock();
            UDFBlock propUDFBlock = UDFFactory.instance().getUDFBlockProp(file.getAbsolutePath());
            udfBlock.setUDFFilePath(file.getAbsolutePath());
            udfBlock.setGuidManager(propUDFBlock.getGuidManager());
            udfBlock.setValidity(propUDFBlock.getValidity());
            udfBlock.setIdentifier(propUDFBlock.getIdentifier());
            currentGroup.addElement(udfBlock);
        }
    }

    public static boolean isUDFSelected(String path) {
        List<String> paths = LogoXMLProperties.getInstance().getLibraryProperties(true);
        for (String udfPath : paths) {
            if (!udfPath.equals(path) && !UDFLibrary.isFileIncluded(udfPath, path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileIncluded(String directory, String filePath) {
        File folder = new File(directory);
        if (!folder.exists() || folder.isFile()) {
            return false;
        }
        if (new File(filePath).isDirectory()) {
            return filePath.startsWith(directory);
        }
        for (File subFile : folder.listFiles()) {
            if (!subFile.getAbsolutePath().equals(filePath) && (!subFile.isDirectory() || !UDFLibrary.isFileIncluded(subFile.getAbsolutePath(), filePath))) continue;
            return true;
        }
        return false;
    }
}

